/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.block.food;

import com.mojang.datafixers.util.Pair;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightItems;
import com.renyigesai.immortalers_delight.util.ItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TartareChickenBigMealBlock
extends HorizontalDirectionalBlock {
    public static final IntegerProperty BITES = IntegerProperty.m_61631_((String)"bites", (int)0, (int)8);
    public static final VoxelShape BOX = TartareChickenBigMealBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0);

    public TartareChickenBigMealBlock(BlockBehaviour.Properties p_54120_) {
        super(p_54120_);
        super.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BITES, (Comparable)Integer.valueOf(0))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return BOX;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack hand_stack = player.m_21120_(hand);
        if (hand_stack.m_150930_(Items.f_42399_)) {
            return this.takeServing(state, level, pos, player);
        }
        if (!hand_stack.m_150930_(Items.f_42399_)) {
            return this.eat(state, level, pos, player);
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    public InteractionResult eat(BlockState state, Level level, BlockPos pos, Player player) {
        int bites = (Integer)state.m_61143_((Property)BITES);
        if (!player.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        int eatCount = 1;
        int i = 1;
        while (bites + i <= 9 && player.m_36391_(false)) {
            eatCount = i++;
            player.m_36324_().m_38712_((Item)ImmortalersDelightItems.TARTARE_CHICKEN.get(), new ItemStack((ItemLike)ImmortalersDelightItems.TARTARE_CHICKEN.get()));
            level.m_142346_((Entity)player, GameEvent.f_157806_, pos);
            level.m_5594_(null, pos, SoundEvents.f_11912_, SoundSource.PLAYERS, 0.8f, 0.8f);
        }
        this.addFoodPoisonEffect(new ItemStack((ItemLike)ImmortalersDelightItems.TARTARE_CHICKEN.get()), level, (LivingEntity)player, eatCount);
        if (bites + eatCount < 9) {
            this.setBlock(bites + eatCount, state, level, pos);
        } else {
            level.m_46961_(pos, false);
            vectorwing.farmersdelight.common.utility.ItemUtils.spawnItemEntity((Level)level, (ItemStack)new ItemStack((ItemLike)Items.f_42399_), (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (double)0.0, (double)0.0, (double)0.0);
            level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8f, 0.8f);
        }
        return InteractionResult.SUCCESS;
    }

    private void addFoodPoisonEffect(ItemStack p_21064_, Level p_21065_, LivingEntity p_21066_, int timeBuffer) {
        Item item = p_21064_.m_41720_();
        if (item.m_41472_()) {
            for (Pair pair : p_21064_.getFoodProperties(p_21066_).m_38749_()) {
                if (p_21065_.f_46443_ || pair.getFirst() == null) continue;
                if (timeBuffer > 1) {
                    int time = ((MobEffectInstance)pair.getFirst()).m_19557_() * timeBuffer;
                    int lv = ((MobEffectInstance)pair.getFirst()).m_19564_();
                    p_21066_.m_7292_(new MobEffectInstance(((MobEffectInstance)pair.getFirst()).m_19544_(), time, lv));
                    continue;
                }
                p_21066_.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
            }
        }
    }

    public InteractionResult takeServing(BlockState state, Level level, BlockPos pos, Player player) {
        int bites = (Integer)state.m_61143_((Property)BITES);
        ItemUtils.givePlayerItem(player, new ItemStack((ItemLike)ImmortalersDelightItems.TARTARE_CHICKEN.get()));
        if (bites < 8) {
            this.setBlock(bites + 1, state, level, pos);
        } else {
            level.m_46961_(pos, false);
            vectorwing.farmersdelight.common.utility.ItemUtils.spawnItemEntity((Level)level, (ItemStack)new ItemStack((ItemLike)Items.f_42399_), (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (double)0.0, (double)0.0, (double)0.0);
        }
        level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    public void setBlock(int variate, BlockState state, Level level, BlockPos pos) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(variate)), 3);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_());
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_280296_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BITES, f_54117_});
    }
}

